//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "relatywstereo.h"
#include "math.h"
//---------------------------------------------------------------------------
//	Konstruktor gwny, inicjujcy wszystkie parametry projekcji.
TRelatywStereo :: TRelatywStereo( TPunkt obs,     //pozycja obserwatora
    int xe0, int ye0, int eszer, int ewys,  //okno ekranowe
    double v,                       //prdko
    double baza,                    //odlego midzy oczami
    TCanvas *Acnv,                  //aparat graficzny
    StylPatrzenia sp/*=Zezem*/,     //typ okularw stereo
    double odl_ekr/*=0.5*/)
{
 TPunkt Lobs, Robs;                 //pozycja lewego i prawego oka
 int Lxe0, Lye0, Leszer, Lewys;     //oklo ekranowe obrazu dla lewego oka
 int Rxe0, Rye0, Reszer, Rewys;     //oklo ekranowe obrazu dla lewego oka
 double r1;                         //odlego obserwatora w paszczynie OXY
 double sf, cf, b = baza/2;         //pomocnicze

 r1 = sqrt( obs.x * obs.x + obs.y * obs.y);
 if( r1 != 0)
 {
    sf = obs.y / r1;                //sin( fi)
    cf = obs.x / r1;                //cos( fi)
 }
 else
 {
    sf = 0;
    cf = 1;
 }

 Lobs.x = obs.x + b * sf;           //wsprzdne lewego oka
 Lobs.y = obs.y - b * cf;
 Lobs.z = obs.z;

 Robs.x = obs.x - b * sf;           //wsprzdne prawego oka
 Robs.y = obs.y + b * cf;
 Robs.z = obs.z;

 switch( sp)
 {
  case Zezem:                       //lewy obraz z prawej i odwrotnie
            Lxe0 = xe0 + eszer / 2;
            Lye0 = ye0;
            Leszer = eszer / 2;
            Lewys = ewys;
            Rxe0 = xe0;
            Rye0 = ye0;
            Reszer = eszer / 2;
            Rewys = ewys;
            break;
  case Peryskopy:                   //lewy obraz z lewej i prawy z prawej
            Lxe0 = xe0;
            Lye0 = ye0;
            Leszer = eszer / 2;
            Lewys = ewys;
            Rxe0 = xe0 + eszer / 2;
            Rye0 = ye0;
            Reszer = eszer / 2;
            Rewys = ewys;
            break;
  case Anaglif:                     //lewy i prawy obraz w tym samym miejscu
            Lxe0 = xe0;
            Lye0 = ye0;
            Leszer = eszer;
            Lewys = ewys;
            Rxe0 = xe0;
            Rye0 = ye0;
            Reszer = eszer;
            Rewys = ewys;
            break;
 }

 L = new TRelatyw3d( Lobs, Lxe0, Lye0, Leszer, Lewys, v, Acnv, odl_ekr);
 R = new TRelatyw3d( Robs, Rxe0, Rye0, Reszer, Rewys, v, Acnv, odl_ekr);
}
//---------------------------------------------------------------------------
//  Destruktor likwiduje obiekty Renderujce obraz dla lewego i prawego oka.
TRelatywStereo :: ~TRelatywStereo()
{
 delete R;
 delete L;
}
//---------------------------------------------------------------------------
//  Wykrelenie punktu dla lewego i prawego oka
bool TRelatywStereo :: punkt_stereo( TPunkt p,
        TColor Lkolor/*=clBlack*/, TColor Rkolor/*=clBlack*/)
{
 bool ret = true;

 if( !L -> punkt_relatyw( p, Lkolor))
    ret = false;

 if( !R -> punkt_relatyw( p, Rkolor))
    ret = false;

 return ret;
}
//---------------------------------------------------------------------------
//  Wykrelenie linii dla lewego i prawego oka
bool TRelatywStereo :: linia_stereo( TPunkt p1, TPunkt p2, int il_podzial,
        TColor Lkolor/*=clBlack*/, TColor Rkolor/*=clBlack*/)
{
 bool ret = true;

 if( !L -> uproszczona_linia_relatyw( p1, p2, il_podzial, Lkolor))
    ret = false;

 if( !R -> uproszczona_linia_relatyw( p1, p2, il_podzial, Rkolor))
    ret = false;

 return ret;
}
//---------------------------------------------------------------------------
//  Wykrelenie czworokta w wersji dla lewego i prawego oka
bool TRelatywStereo :: czworokat_stereo( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4,
        int il_podzial,
        TColor Lkolor1/*=clBlack*/, TColor Rkolor1/*=clBlack*/,    //kolory konturw
        TColor Lkolor2/*=clWhite*/, TColor Rkolor2/*=clWhite*/)    //kolory wypenie
{
 bool ret = true;

 if( !L -> uproszczony_czworokat_relatyw( p1, p2, p3, p4, il_podzial, Lkolor1, Lkolor2))
    ret = false;

 if( !R -> uproszczony_czworokat_relatyw( p1, p2, p3, p4, il_podzial, Rkolor1, Rkolor2))
    ret = false;

 return ret;
}

